Imports System
Imports System.Runtime.Serialization
Imports System.Runtime.Serialization.Formatters.Binary
Imports System.IO
Imports System.Collections

'
' Instances of this class respond to action events by serializing the
' instance of GameModel associated with this object.
'
Public Class Serializer
    Private ui As UserInterface
    Private model As GameModel

    ' Constructor
    ' ui - The UserInterface object that this object will obtain
    '      file names from.
    ' model - The GameModel object that this object will be
    '         responsible for serializing.
    Public Sub New(ByVal ui As UserInterface, ByVal model As GameModel)
        Me.ui = ui
        Me.model = model
    End Sub 'New

    '
    ' When a user interface event occurs that implies the serialization
    ' of this game's state to a file, the user interface calls this
    ' method.
    '
    Public Sub ActionPerformed(ByVal o As Object, ByVal a As EventArgs)
        Try
            Dim s As Stream = File.Open(ui.SaveFileName, FileMode.Create)
            Dim f As New BinaryFormatter()
            f.Serialize(s, Me)
            s.Close()
        Catch e As Exception
            ui.DisplayError(e.Message)
        End Try
    End Sub
End Class 'Serializer 
